/*
 * LlistarClients.java
 *
 * Created on 8 de junio de 2008, 16:52
 */

package actions;

import entitats.Client;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;
import locals.OpcionsLocal;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author Administrador
 * @version
 */

public class LlistarLocals extends Action {
    
    DataSource ds = null;
    Connection con = null;
    String sql;
    ArrayList <Local> locals = new ArrayList();
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        locals.OpcionsLocal opcions = (OpcionsLocal) form;
        locals.clear();
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            PreparedStatement sentencia = null;
            
            if (!opcions.isAlta() && !opcions.isPendent()){
                opcions.setError("<font color='red'>S'ha de seleccionar com a minim un tipus de locals</font>");
                return mapping.findForward("ok");
            }
            
            sql = "SELECT * FROM locals";
            
            if (!opcions.isAlta() || !opcions.isPendent()){
                sql += " WHERE";
                if (opcions.isAlta())
                    sql += " actiu = 1";
                else if (opcions.isPendent())
                    sql += " actiu = 0";
            }
            
            rs = st.executeQuery(sql);
            
            if (rs.next()) {
                do{
                    Local local = new Local();
                    local.setAdresa(rs.getString("adresa"));
                    local.setCaracteristiques(rs.getString("caracteristiques"));
                    local.setCaracteristiquesPolivalents(rs.getString("caracteristiques_polivalent"));
                    local.setCodiLocal(rs.getString("codi_local"));
                    local.setIdLocal(rs.getInt("id"));
                    local.setIdPropietari(rs.getInt("id_propietari"));
                    local.setPreu(rs.getFloat("preu"));
                    local.setRestriccions(rs.getString("restriccions"));
                    local.setSuperficie(rs.getFloat("superficie"));
                    local.setTipus(rs.getString("tipus"));
                    local.setVolum(rs.getFloat("volum"));
                    local.setIdZona(rs.getInt("id_zona"));
                    locals.add(local);
                } while (rs.next());
            } else {
                opcions.setLlista("<b>La cerca no ha donat resultats</b>");
                return mapping.findForward("ok");
            }
            
            opcions.setLlistatLocals(locals);
            
        }catch(Exception excepcio){
            System.out.println("ERROR: "+excepcio.getMessage());
            opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarClients:<br>" +
                    ""+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarClients:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}